# Graphviz Examples

Note: Example graphs used to generate images with the https://www.graphviz.org for their https://www.graphviz.org/gallery/.
Origin Notes: The graphs have various origins, most of which are described on the Graphviz https://www.graphviz.org/gallery/.
graph features handled: Clusters (pre-existing), Directed edges, Labeled nodes, N-layers
Graph features in papers: layered graphs,n-layers,large,generic
Origin Paper: An open graph visualization system and its applications to software engineering (https://www.notion.so/An-open-graph-visualization-system-and-its-applications-to-software-engineering-f85328b544b744969aedaf56b21d25a5?pvs=21)
Originally found at: https://gitlab.com/graphviz/graphviz/-/tree/main/tests/graphs
Size: 1-1464 nodes, 0-5806 edges
Number of Graphs: 195
Child collections: Control Flow Graphs (Control%20Flow%20Graphs%20af079f199a2c402d8633f6d41101934b.md)
Appeared in years: 2010,2016,2023
Type of Collection: Uniform Benchmark
is it stored properly?: No
must be analyzed: No
In repo?: Yes
Related to Literature - Algorithm (1) (Dataset tag relations): Node Overlap Removal by Growing a Tree (https://www.notion.so/Node-Overlap-Removal-by-Growing-a-Tree-534753c850d64167892bde314403e2d6?pvs=21), Optimal k-level planarization and crossing minimization (https://www.notion.so/Optimal-k-level-planarization-and-crossing-minimization-97c176b0cca14663a27827f2f68f6478?pvs=21)
cleaned format?: Yes
duplicate?: No
link works?: No
Added in paper: No
OSF link json: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d90ea91101aa0c9e6a0c97
Origin paper plaintext: An open graph visualization system and its applications to software engineering
Page id: e90aec42f02c4e8b8a6b8727fe2f86ae
unavailable/skip: No
Cleaned ALL data: No
OSF link gexf: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d948d60c2b4d0e8d38620a
OSF link gml: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d96ce394a6be111712e991
OSF link graphml: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d970e60c2b4d0f65386519
first look: No
sparkline data: {'min': 1, 'max': 1464, 'step_size': 50, 'num_bins': 30, 'bins': [0, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000, 1050, 1100, 1150, 1200, 1250, 1300, 1350, 1400, 1450], 'num_nodes': [169, 11, 6, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 2]}
Related to Literature - Algorithm (Dataset tag relations) 1: Optimal k-level planarization and crossing minimization (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Optimal%20k-level%20planarization%20and%20crossing%20minimiz%204b0f5887f98f4b95acccc354d6f9e518.md), Node Overlap Removal by Growing a Tree (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Node%20Overlap%20Removal%20by%20Growing%20a%20Tree%20c69ee6ac8232493b9f8d26ed56235a6b.md), FORBID: Fast Overlap Removal by Stochastic GradIent Descent for Graph Drawing (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/FORBID%20Fast%20Overlap%20Removal%20by%20Stochastic%20GradIent%20b58c9e4a77174a48b0c023b62f66c6d7.md)

# Body

### Statistics

![four_in_one.svg](Graphviz%20Examples%20e90aec42f02c4e8b8a6b8727fe2f86ae/four_in_one.svg)

### Descriptions from Literature

From “[Node Overlap Removal by Growing a Tree](https://doi.org/10.7155/jgaa.00442)”:

> Our data includes the same set of graphs that was used by the authors of PRISM to compare it with other algorithms [6]. The dataset is available in the Graphviz open source package.
> 

From “[Optimal k-level planarization and crossing minimization](https://doi.org/10.1007/978-3-642-18469-7_22)”:

> The first set of graphs are all the hierarchical network diagrams appearing in the GraphViz gallery [3]… Table 1 shows the results of minimizing edge crossings and maximizing planar subgraphs with MIP and SAT solvers, as well as the crossings resulting in the Graphviz heuristic layout for graphs from the GraphViz gallery.
> 

### Example Figures

From “[Node Overlap Removal by Growing a Tree](https://doi.org/10.7155/jgaa.00442)”:

![Screen Shot 2023-08-16 at 3.44.08 PM.png](Graphviz%20Examples%20e90aec42f02c4e8b8a6b8727fe2f86ae/Screen_Shot_2023-08-16_at_3.44.08_PM.png)

![Screen Shot 2023-08-16 at 3.44.43 PM.png](Graphviz%20Examples%20e90aec42f02c4e8b8a6b8727fe2f86ae/Screen_Shot_2023-08-16_at_3.44.43_PM.png)

From “[FORBID: Fast Overlap Removal by Stochastic GradIent Descent for Graph Drawing](https://link.springer.com/chapter/10.1007/978-3-031-22203-0_6)”:

![Screen Shot 2023-08-16 at 3.50.39 PM.png](Graphviz%20Examples%20e90aec42f02c4e8b8a6b8727fe2f86ae/Screen_Shot_2023-08-16_at_3.50.39_PM.png)

From “[Optimal k-level planarization and crossing minimization](https://doi.org/10.1007/978-3-642-18469-7_22)”:

![Screen Shot 2023-08-16 at 3.35.58 PM.png](Graphviz%20Examples%20e90aec42f02c4e8b8a6b8727fe2f86ae/Screen_Shot_2023-08-16_at_3.35.58_PM.png)